
package kom.itbeankit.common;


import kom.itbeankit.common.itbeanframe.*;
/***********************************************************************************************
 * This class implements efficient and thread-safe multi-cast event dispatching
 * for the AWT events defined in the java.awt.event package. This class will
 * manage an immutable structure consisting of a chain of event listeners and will
 * dispatch events to those listeners. Because the structure is immutable, it is safe
 * to use this API to add/remove listeners during the process of an event dispatch
 * operation. You use this class in the same way as the superclass java.awt.AWTEventMulticaster.
 * @see java.awt.AWTEventMulticaster
 * @version 1.02, 05/05/98
 * @author Christian C. Hoffmann
 ***********************************************************************************************/
public class ItBeanEventMulticaster extends java.awt.AWTEventMulticaster implements kom.itbeankit.common.ItBeanCommunicationListener {



/**
 * ItBeanEventMulticaster constructor comment.
 * @param a java.util.EventListener
 * @param b java.util.EventListener
 */
protected ItBeanEventMulticaster(java.util.EventListener a, java.util.EventListener b) {
	super(a, b);
}
/**
 * This method adds ItBeanCommunicationListener a with 
 * ItBeanCommunicationListener b and
 * returns the resulting multicast listener.
 * @param a common.ItBeanCommunicationListener
 * @param b common.ItBeanCommunicationListener
 */
public static ItBeanCommunicationListener add(ItBeanCommunicationListener a, ItBeanCommunicationListener b) {
	return (ItBeanCommunicationListener) addInternal(a,b);
}
/**
 * Handles the bean completed event by invoking the
 * beanCompleted() methods on listener-a and listener-b.
 * @param e common.ItBeanCommunicationEvent
 */
public void beanCompleted(ItBeanCommunicationEvent e) {
	((ItBeanCommunicationListener)a).beanCompleted(e);
	((ItBeanCommunicationListener)b).beanCompleted(e);
	return;
}
/**
 * Handles the bean interrupted event by invoking the
 * beanInterrupted() methods on listener-a and listener-b.
 * @param e common.ItBeanCommunicationEvent
 */
public void beanInterrupted(ItBeanCommunicationEvent e) {
	((ItBeanCommunicationListener)a).beanInterrupted(e);
	((ItBeanCommunicationListener)b).beanInterrupted(e);
	return;
}
/**
 * Handles the bean terminated event by invoking the
 * beanTerminated() methods on listener-a and listener-b.
 * @param e common.ItBeanCommunicationEvent
 */
public void beanStarted(ItBeanCommunicationEvent e) {
	((ItBeanCommunicationListener)a).beanStarted(e);
	((ItBeanCommunicationListener)b).beanStarted(e);
	return;
}
/**
 * Handles the bean terminated event by invoking the
 * beanTerminated() methods on listener-a and listener-b.
 * @param e common.ItBeanCommunicationEvent
 */
public void beanTerminated(ItBeanCommunicationEvent e) {
	((ItBeanCommunicationListener)a).beanTerminated(e);
	((ItBeanCommunicationListener)b).beanTerminated(e);
	return;
}
/**
 * Removes the old ItBeanCommunicationListener from ItBeanCommunicationListener l 
 * and returns the resulting multicast listener.
 * @return common.ItBeanCommunicationListener
 * @param l common.ItBeanCommunicationListener
 * @param oldl common.ItBeanCommunicationListener
 */
public static ItBeanCommunicationListener remove(ItBeanCommunicationListener l, ItBeanCommunicationListener oldl) {
	return (ItBeanCommunicationListener)removeInternal(l, oldl);
}
}